function [Gu_x, optval,alltime,fea] = centroid_Gurobi(stride, supp, w, c0, options)

N=length(stride);
M=length(w);
m_vec=stride;
m_vec = int64(m_vec) ;
m_vec_cumsum = [0,cumsum(m_vec)] ;

Gu_x=c0;

m=length(Gu_x.w);

n_row=M+N*(m-1)+1+N; % The total number of rows of A
n_col=(M+1)*m+N+1;     % The total number of columns of A
Mm=M*m;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Constructing b,c
b = zeros( M+N*m+1,1 );
b(1:M) = w';
b(M+N*m+1) = 1;
b(M+1:m:end-1-N) = [];
beq = [b; zeros(N,1)];    % preconditioning;
% C = pdist2(IPMx.supp', supp', 'sqeuclidean');
c = [zeros(n_col-1,1); 1];

%% Formulate the Constraints Coefficient Matrix
row1 = kron( (1:M)' , ones(m,1));
row2 = zeros( M*(m-1) , 1 );
for i=1:N
    index= (m_vec_cumsum(i)*(m-1)+1) : ((m_vec_cumsum(i+1))*(m-1));
    row2(index ) = kron(ones(m_vec(i),1), (M+(i-1)*(m-1)+1 : M+i*(m-1))');
end
row3 = (n_row-N)*ones(m,1);
row = [row1 ; row2 ; row3];

col1 = (1:Mm)' ;
col2 = (1:Mm)' - kron( (m*(1:M)+1-m)' , [1;zeros(m-1,1)] );
col2 = col2(find(col2));
col3 = (n_col-m+1-N-1 : n_col-N-1)' ;
col = [col1 ; col2 ; col3];

val = ones( Mm + M*(m-1)+m,1 );

A_true = sparse ( row , col , val  );
A_true( M+1: M+N*(m-1), n_col-m+2-N-1 : n_col-N-1) = -kron( ones(N,1), speye(m-1) );

D = pdist2(Gu_x.supp', supp', 'sqeuclidean');
D = reshape(D, 1, []);
for i=1:N
    A_true = [A_true;
              zeros(1,m*m_vec_cumsum(i)) ,D(m*m_vec_cumsum(i)+1 : m*m_vec_cumsum(i+1)) ,zeros(1,Mm-m*m_vec_cumsum(i+1)+m)
             ];
end
H = [zeros(M+N*(m-1)+1,N+1);
     eye(N) ,-ones(N,1)
    ];
Aeq = [A_true ,H];

clear col1 col2 col3 col row1 row2 row3 row val H


%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Solve with Gurobi
tic;
x = sdpvar(n_col,1);
Cons = [Aeq * x == beq, x >= 0];
Objective = c'*x;
sol = optimize(Cons,Objective);
gux = value(x);

Gu_x.w = gux(end-m+1-N-1:end-N-1);
Gu_x.x = gux(end) - gux(end-N:end-1);
Guopt = gux(end);
fprintf('final optimal value of default gurobi = %f\n', Guopt);
optval = Guopt;

alltime = toc;


%% feasibility
x=gux;
err1 = norm(Aeq(1:M,:)*x-beq(1:M))/(1+norm(x(1:end-m))+norm(beq(1:M)));
err2 = norm(Aeq(M+1:end-1,:)*x-beq(M+1:end-1))/(1+norm(x(1:end-m))+norm(beq(M+1:end-1)));
err3 = abs(sum(x(end-m+1:end))-1)/norm(x(end-m+1:end));
fea = max([err1,err2,err3]);
end
